import { Briefcase, Mail, Phone, MapPin, Linkedin, Twitter, Instagram } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Briefcase size={32} strokeWidth={2} className="footer-logo-icon" />
              <span className="footer-logo-text">CareerPath</span>
            </div>
            <p className="footer-description">
              Современные консультации по карьере. Помогаем найти свой путь к успеху.
            </p>
            <div className="footer-social">
              <a href="#" className="social-link" aria-label="LinkedIn">
                <Linkedin size={18} strokeWidth={2} />
              </a>
              <a href="#" className="social-link" aria-label="Twitter">
                <Twitter size={18} strokeWidth={2} />
              </a>
              <a href="#" className="social-link" aria-label="Instagram">
                <Instagram size={18} strokeWidth={2} />
              </a>
            </div>
          </div>
          
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Mail size={16} strokeWidth={2} />
                <a href="mailto:hello@careerpath.ru">hello@careerpath.ru</a>
              </li>
              <li>
                <Phone size={16} strokeWidth={2} />
                <a href="tel:+78001234567">+7 (800) 123-45-67</a>
              </li>
              <li>
                <MapPin size={16} strokeWidth={2} />
                <span>Санкт-Петербург, Невский пр., 28</span>
              </li>
            </ul>
          </div>
          
          <div className="footer-section">
            <h3 className="footer-title">Услуги</h3>
            <ul className="footer-links">
              <li><a href="#">Резюме и портфолио</a></li>
              <li><a href="#">Подготовка к интервью</a></li>
              <li><a href="#">Карьерный переход</a></li>
              <li><a href="#">Профессиональный коучинг</a></li>
            </ul>
          </div>
        </div>
        
        <div className="footer-bottom">
          <p>&copy; 2025 CareerPath. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

